#include <qpainter.h>
#include <qwt_dial_needle.h>
#include "cSpeedMeter.h"

cSpeedMeter::cSpeedMeter(QWidget *parent): QwtDial(parent), d_label("m/s")
{
    setWrapping(false);
    setReadOnly(true);

    setOrigin(125.0);
    setScaleArc(0.0, 270.0);
    scaleDraw()->setSpacing(8);

    QwtDialSimpleNeedle *needle = new QwtDialSimpleNeedle(QwtDialSimpleNeedle::Arrow, true, Qt::red, QColor(Qt::gray).light(130));
    setNeedle(needle);

    setScaleOptions(ScaleTicks | ScaleLabel);
    setScaleTicks(0, 4, 8);
}

void cSpeedMeter::setLabel(const QString &label)
{
    d_label = label;
    update();
}

QString cSpeedMeter::label() const
{
    return d_label;
}

void cSpeedMeter::drawScaleContents(QPainter *painter, const QPoint &center, int radius) const
{
    QRect rect(0, 0, 2 * radius, 2 * radius - 10);
    rect.moveCenter(center);

    const QColor color =

    palette().color(QPalette::Text);
    painter->setPen(color);

    const int flags = Qt::AlignBottom | Qt::AlignHCenter;
    painter->drawText(rect, flags, d_label);
}
